import React from 'react';

interface BriskNightThemeProps {
  mode: 'light' | 'dusky';
}

const BriskNightTheme: React.FC<BriskNightThemeProps> = ({ mode }) => {
  const styles = {
    light: {
      backgroundColor: '#f0f8ff',
      color: '#333333',
      accentColor: '#4169e1',
      secondaryColor: '#e6f3ff',
      borderColor: '#b0c4de',
      backgroundImage: 'url("/public/images/royalty-free/neon tunnel goranH.jpg")',
    },
    dusky: {
      backgroundColor: '#1a1a2e',
      color: '#ffffff',
      accentColor: '#4b0082',
      secondaryColor: '#2a2a4a',
      borderColor: '#483d8b',
      backgroundImage: 'url("/public/images/royalty-free/neon jellyfish nika_akin.jpg")',
    },
  };

  return (
    <div style={styles[mode]}>
      {/* Rest of the component content */}
    </div>
  );
};

export default BriskNightTheme; 